#ifndef __CBrush__
#define __CBrush__

#include "../Basics/CAlphaColour.hpp"
using Exponent::GUI::Basics::CAlphaColour;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Graphics
		{
			/**
			 * @class CBrush CBrush.hpp
			 * @brief Used for filling areas
			 *
			 * @date 01/10/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CBrush.hpp,v 1.4 2007/02/08 21:07:54 paul Exp $
			 */
			class CBrush
			{
			public:

				/**
				 * Construction
				 */
				CBrush();

				/**
				 * Destruction
				 */
				virtual ~CBrush();

//	===========================================================================

				/**
				 * Deinitialise
				 */
				void uninitialise();

//	===========================================================================

				/** @cond */
				#ifdef WIN32
				/** @endcond */
					/**
					 * Initialise
					 * @param hdc The windowss draw context
					 * @param colour The colour to use
					 */
					void initialise(HDC hdc, const CAlphaColour &colour);

					/**
					 * Set the colour to be transparent
					 */
					void setColourToNullBrush();

					/**
					 * Get the associated dc
					 * @retval const HDC The brush context
					 */
					const HDC getBrushHdc() const { return m_hdc; }

					/**
					 * Get a mutable reference to the hdc
					 * @retval HDC The brush hdc 
					 */
					HDC getMutableBrushHdc() { return m_hdc; }

					/**
					 * Get the brush itself
					 * @retval const HBRUSH The window brush
					 */
					const HBRUSH getBrush() const { return m_brush; }
				/** @cond */
				#else
				/** @endcond */
					/**
					 * Initialise
					 * @param drawContext The mac draw context
					 * @param colour The colour to use
					 */
					void initialise(CGContextRef drawContext, const CAlphaColour &colour);

					/**
					 * Get the draw context
					 * @retval CGContextRef The mac context
					 */
					CGContextRef getContextRef() const { return m_drawContext; }
				/** @cond */
				#endif
				/** @endcond */

				/**
				 * Set the colour from an alpha colour
				 * @param colour The colour to use
				 */
				void setColour(const CAlphaColour &colour);

//	===========================================================================

				/**
				 * Get hte colour
				 * @retval const CAlphaColour& The current colour
				 */
				const CAlphaColour &getColour() const { return m_colour; }

//	===========================================================================

			protected:

//	===========================================================================

				/**
				 * Create the brush
				 */
				void createBrush();

				/**
				 * Delete the brush
				 */
				void deleteBrush();

//	===========================================================================

				/** @cond */
				#ifdef WIN32
				/** @endcond */
					HDC m_hdc;					/**< Host drawing context */
					HGDIOBJ m_hOld;				/**< Old windows brush object */
					HBRUSH m_brush;				/**< Windows brush handle */
				/** @cond */
				#else
				/** @endcond */
					CGContextRef m_drawContext;	/**< Host drawing context */
				/** @cond */
				#endif
				/** @endcond */

				CAlphaColour m_colour;			/**< Filling colour */

			};
		}
	}
}
#endif	// End of CBrush.hpp